<?php

/*
	Примеры категории stats.
*/

/*
	ВНИМАНИЕ! В bootstrap.php - прописаны данные для авторизации и инициализация API библиотеки.
	Пожалуйста ознакомьтесь с этим файлом.
*/
require_once(__DIR__ .'/bootstrap.php');



/*

	Разъяснения данных в информации о звонке:
		- companyID - идентификатор компании в АТС Binotel
		- generalCallID  - главный идентификатор звонка
		- callID  - идентификатор записи разговора (используется для получения ссылки на запись разговора)
		- startTime  - время начала звонка
		- callType  - тип звонка: входящий - 0, исходящий  - 1
		- internalNumber  - внутренний номер сотрудника / группы в виртуальной АТС (если звонок не был принят)
		- internalAdditionalData  - номер группы в виртуальной АТС (если звонок был принят)
		- externalNumber  - телефонный номер клиента
		- customerData:
			- id  - идентификатор клиента в Мои клинтах
			- name  - имя клиента в Мои клинтах
		- employeeName  - имя сотрудника
		- employeeEmail  - email сотрудника
		- dstNumbers  - спискок номеров которые были в обработке звонка (когда звонок входящий это будет список попыток звонков)
			- dstNumber  - номер кому звонили (когда звонок входящий это будет внутренняя линия сотрудника или группа при груповом звонке, при исхощяем звонке это будет номер на который звонит сотрудник)
		- waitsec  - ожидание до соединения
		- billsec  - длительность разговора
		- disposition  - состояние звонка (ANSWER - успешный звонок, TRANSFER - успешный звонок который был переведен, ONLINE - звонок в онлайне, BUSY - неуспешный звонок по причине занятости, NOANSWER - неуспешный звонок по причине не ответа, CANCEL - неуспешный звонок по причине отмены звонка, CONGESTION - неуспешный звонок, CHANUNAVAIL - неуспешный звонок, VM - голосовая почта без сообщения, VM-SUCCESS - голосовая почта с сообщением, SMS-SENDING - SMS сообщение на отправке, SMS-SUCCESS - SMS сообщение успешно отправлено, SMS-FAILED - SMS сообщение не отправлено, SUCCESS - успешно принятый факс, FAILED - непринятый факс)
		- isNewCall  - был ли входящий звонок новым
		- didNumber  - номер на который пришел вызов во входящем звонке
		- didName  - имя номера на который пришел вызов во входящем звонке
		- trunkNumber  - номер через который совершался исходящий звонок
		- smsContent  - содержимое SMS сообщения

		- callTrackingData - Call Tracking информация (если звонок осуществлялся по Call Tracking номеру)
			- id  - Call Tracking id
			- gaClientId  - Google Analytics Client ID
			- gaTrackingId  - идентификатор отслеживания сайта в Google Analytics
			- utm_source  - метка utm_source
			- utm_medium  - метка utm_medium
			- utm_campaign  - метка utm_campaign
			- utm_content  - метка utm_content
			- utm_term  - метка utm_term
			- ipAddress  - IP адрес клиента
			- geoipCountry - страна по geoip
			- geoipRegion - регион по geoip
			- geoipCity - город по geoip
			- geoipOrg - организация по geoip
			- domain  - сайт
			- timeSpentOnSiteBeforeMakeCall  - пребывания на сайте до совершения звонка в секундах
			- firstVisitAt  - клиент зашел на сайт впервые

		- getCallData - GetCall информация (если звонок осуществлялся используя активный виджет заказа звонка на сайте)
			- id  - GetCall id
			- gaClientId  - Google Analytics Client ID
			- gaTrackingId  - идентификатор отслеживания сайта в Google Analytics
			- utm_source  - метка utm_source
			- utm_medium  - метка utm_medium
			- utm_campaign  - метка utm_campaign
			- utm_content  - метка utm_content
			- utm_term  - метка utm_term
			- ipAddress  - IP адрес клиента
			- geoipCountry - страна по geoip
			- geoipRegion - регион по geoip
			- geoipCity - город по geoip
			- geoipOrg - организация по geoip
			- domain  - сайт
			- isNewNumber  - заказ сделан впервые
			- createdAt  - звонок заказан в
			- callAt  - звонок заказан на
			- processedAt  - звонок обработан в
			- isProcessed  - звонок обработан
			- requestsCounter  - количество попыток заказа звонка клиентом
			- attemptsCounter  - количество попыток соединения сотрудника с клиентом
			- employeesDontAnswerCounter  - сколько раз не взяли трубку сотрудники
			- fullUrl  - заказ сделан со страницы
			- description  - дополнительное описание

*/



/*
	Пример 1: входящие или исходящие звонки за период времени.

	Вариант адреса:
		- incoming-calls-for-period - для входящих звонков
		- outgoing-calls-for-period - для исходящих звонков
		- calltracking-calls-for-period - для CallTracking звонков

	Параметры:
		- startTime  - время начала выбора звонков (в формате unix timestamp)
		- stopTime  - время окончания выбора звонков (в формате unix timestamp)
*/

$result = $api->sendRequest('stats/outgoing-calls-for-period', array(
	'startTime' => 1370034000, // Sat, 01 Jun 2013 00:00:00 +0300
	'stopTime' => 1370120399 // Sat, 01 Jun 2013 23:59:59 +0300
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 2: входящие или исходящие звонки с N времени по настоящее время.

	Вариант адреса:
		- all-incoming-calls-since - для входящих
		- all-outgoing-calls-since - для исходящих

	Параметры:
		- timestamp  - время начала выбора звонков (в формате unix timestamp)
*/

$lastRequestTimestamp = 1370034000; // Sat, 01 Jun 2013 00:00:00 +0300

$result = $api->sendRequest('stats/all-incoming-calls-since', array(
	'timestamp' => $lastRequestTimestamp
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 3: звонки которые в онлайне.
	Параметры: пустой массив.
*/

$result = $api->sendRequest('stats/online-calls', array());

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 4: звонки за день (как входящие, так и исходящие).

	Параметры:
		- dayInTimestamp  - день (в формате unix timestamp, при отсутствии этого параметра звонки буду взяты за сегодня)
*/

$result = $api->sendRequest('stats/list-of-calls-per-day', array(
	'dayInTimestamp' => mktime(0, 0, 0, 11, 25, 2015)
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 5: звонки за период времени (как входящие, так и исходящие) (! но не больше 24 часов).

	Параметры:
		- startTime  - время начала выбора звонков (в формате unix timestamp)
		- stopTime  - время окончания выбора звонков (в формате unix timestamp)
*/

$result = $api->sendRequest('stats/list-of-calls-for-period', array(
	'startTime' => 1370034000, // Sat, 01 Jun 2013 00:00:00 +0300
	'stopTime' => 1370048400 // Sat, 01 Jun 2013 04:00:00 +0300
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 6: звонки по внутреннему номеру сотрудника за период времени (как входящие, так и исходящие).

	Параметры:
		- internalNumber  - внутренний номер сотрудника
		- startTime  - время начала выбора звонков (в формате unix timestamp)
		- stopTime  - время окончания выбора звонков (в формате unix timestamp)

	Ограничения: период не может быть больше 7 дней.
*/

$result = $api->sendRequest('stats/list-of-calls-by-internal-number-for-period', array(
	'internalNumber' => '901',
	'startTime' => 1370034000, // Sat, 01 Jun 2013 00:00:00 +0300
	'stopTime' => 1370638799 // Fri, 07 Jun 2013 23:59:59 +0300
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 7: потерянные звонки за сегодня.
	Параметры: пустой массив.
*/

$result = $api->sendRequest('stats/list-of-lost-calls-today', array());

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 8: звонки по номеру телефона (как входящие, так и исходящие).

	Параметры:
		- number  - номер или номера в массиве
*/

$result = $api->sendRequest('stats/history-by-number', array(
	'number' => array('0443334023', '0443334444')
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 9: звонки по идентификатору клиента (как входящие, так и исходящие).

	Параметры:
		- customerID  - идентификатор клиента или идентификаторы клиентов в массиве
*/

$result = $api->sendRequest('stats/history-by-customer-id', array(
	'customerID' => '6611'
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 10: недавние звонки по внутреннему номеру сотрудника (как входящие, так и исходящие). Используется для реализации функции "Мои недавние звонки" для сотрудника.

	Параметры:
		- internalNumber  - внутренний номер сотрудника

	Ограничения: звонки за последние 2 недели и не более 50 звонков.
*/

$result = $api->sendRequest('stats/recent-calls-by-internal-number', array(
	'internalNumber' => '901'
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 11: данные о звонке по идентификатору звонка.

	Параметры:
		- generalCallID  - идентификатор звонка или массив c идентификаторами звонков
*/

$result = $api->sendRequest('stats/call-details', array(
	'generalCallID' => array('2255713', '2256039', '2252553')
));

if ($result['status'] === 'success') {
	var_dump($result['callDetails']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}



/*
	Пример 12: получение ссылки на запись разговора.
	ВНИМАНИЕ: время жизни ссылки на запись разговора 15 минут. Запись на разговор может быть только в звонках с состоянием звонка (disposition): ANSWER, VM-SUCCESS, SUCCESS.

	Параметры:
		- callID  - идентификатор записи разговора
*/

$result = $api->sendRequest('stats/call-record', array(
	'callID' => '12501059'
));

if ($result['status'] === 'success') {
	var_dump($result['url']);
} else {
	printf('REST API ошибка %s: %s %s', $result['code'], $result['message'], PHP_EOL);
}


