<?php

/*
    Примеры API PUSH.

    API PUSH используется для уведомления Вашего скрипта о каждом звонке по состояниям: поступления звонока, ответа на звонок, завершения звонка.
    
    Этот способ работает через HTTP протокол, данные отправляются методом POST.

    С протоколом HTTP можно ознакомится по ссылке: http://ru.wikipedia.org/wiki/HTTP
    С методом POST можно ознакомится по ссылке: http://ru.wikipedia.org/wiki/HTTP#POST


    АТС Binotel отправляет 4 запроса на каждый звонок:
        1) во время поступления звонка
        2) во время ответа на звонок
        3) во время перевода звонка
        4) во время завершения звонка


    Ссылку на Ваш скрипт нужно передать в отдел технической поддержки.
*/


/* 
    Пример POST данных оповещения при поступлении входящего звонка в АТС Binotel.
*/
$postData = array(
    'didNumber' => '0443334000',
    'externalNumber' => '0670219424',
    'internalNumber' => '801',
    'generalCallID' => '2500834',
    'callType' => '0',
    'companyID' => '3041',
    'requestType' => 'receivedTheCall'
);



/* 
    Пример POST данных оповещения при поступлении исходящего звонка в АТС Binotel.
*/
$postData = array(
    'externalNumber' => '0670219424',
    'internalNumber' => '904',
    'generalCallID' => '2590912',
    'callType' => '1',
    'companyID' => '3041',
    'requestType' => 'receivedTheCall'
);



/* 
    Пример POST данных оповещение когда сотрудник ответил на входящий звонок (звонок на группу сотрудников).
*/
$postData = array(
    'didNumber' => '0442334000',
    'externalNumber' => '0670219424',
    'internalNumber' => '904',
    'generalCallID' => '2500834',
    'callType' => '0',
    'companyID' => '3041',
    'requestType' => 'answeredTheCall'
);



/* 
    Пример POST данных оповещение когда сотрудник ответил на входящий или исходящий звонок (прямой звонок на сотрудника).
*/
$postData = array(
    'didNumber' => '0442334000',
    'externalNumber' => '0670219424',
    'internalNumber' => '904',
    'generalCallID' => '2711245',
    'callType' => '0',
    'companyID' => '3041',
    'requestType' => 'answeredTheCall'
);


/* 
    Пример POST данных оповещение когда звонок был переведен.
*/
$postData = array(
    'internalNumber' => '901',
    'generalCallID' => '5031953',
    'companyID' => '3041',
    'requestType' => 'transferredTheCall'
);



/* 
    Пример POST данных оповещение когда звонок завершился.
*/
$postData = array(
    'generalCallID' => '2744830',
    'billsec' => '35',
    'disposition' => 'ANSWER',
    'companyID' => '3041',
    'requestType' => 'hangupTheCall'
);


/*
    Разъяснения данных посылаемых от АТС Binotel:
        - externalNumber  - телефонный номер клиента
        - internalNumber  - внутренний номер сотрудника / группы в виртуальной АТС
        - requestType - тип PUSH запроса
        - generalCallID  - главный идентификатор звонка
        - callType  - тип звонка: входящий - 0, исходящий  - 1
        - companyID - идентификатор компании в АТС Binotel
        - billsec  - длительность разговора
        - disposition  - состояние звонка (ANSWER - успешный звонок, TRANSFER - успешный звонок который был переведен, ONLINE - звонок в онлайне, BUSY - неуспешный звонок по причине занятости, NOANSWER - неуспешный звонок по причине не ответа, CANCEL - неуспешный звонок по причине отмены звонка, CONGESTION - неуспешный звонок, CHANUNAVAIL - неуспешный звонок, VM - голосовая почта без сообщения, VM-SUCCESS - голосовая почта с сообщением, SMS-SENDING - SMS сообщение на отправке, SMS-SUCCESS - SMS сообщение успешно отправлено, SMS-FAILED - SMS сообщение не отправлено, SUCCESS - успешно принятый факс, FAILED - непринятый факс)


    ВНИМАНИЕ! Другие переменные которые присылаются и не описаны выше - являются устаревшими.
    Их использование нежелательно, так как в ближайшее время будут удалены из PUSH API.
*/
