<?php

/*
	Примеры API CALL SETTINGS.

	API CALL SETTINGS используется для управления звонками и интеграции Вашей CRM с АТС Binotel.
	
	Этот способ работает через HTTP протокол, данные отправляются методом POST.
	Дополнительные настройки к звонку должны быть возвращены в JSON.

	С протоколом HTTP можно ознакомится по ссылке: http://ru.wikipedia.org/wiki/HTTP
	С методом POST можно ознакомится по ссылке: http://ru.wikipedia.org/wiki/HTTP#POST
*/


/*
	ВНИМАНИЕ!!!! В целях безопасности, откройте доступ к этому скрипту только с серверов Binotel!
 */

/**
 * List of Binotel servers
 */
$listOfBinotelServers = array(
	'194.88.218.116' => 'my.binotel.ua',
	'194.88.218.114' => 'sip1.binotel.com',
	'194.88.218.117' => 'sip2.binotel.com',
	'194.88.218.118' => 'sip3.binotel.com',
	'194.88.219.67' => 'sip4.binotel.com',
	'194.88.219.78' => 'sip5.binotel.com',
	'194.88.219.70' => 'sip6.binotel.com',
	'194.88.219.71' => 'sip7.binotel.com',
	'194.88.219.72' => 'sip8.binotel.com',
	'194.88.219.79' => 'sip9.binotel.com',
	'194.88.219.80' => 'sip10.binotel.com'
);

/**
 * Allow access only from Binotel server
 */
if (!isset($listOfBinotelServers[$_SERVER['REMOTE_ADDR']])) {
	die(sprintf('Access denied!%s', PHP_EOL));
}



/*
	Информация по интеграции Вашей CRM с АТС Binotel.

	У нас важной частью в интеграции является плагин для Chrome https://chrome.google.com/webstore/detail/%D0%B2%D0%B8%D1%80%D1%82%D1%83%D0%B0%D0%BB%D1%8C%D0%BD%D0%B0%D1%8F-%D0%B0%D1%82%D1%81-binotel/pejnjcmcdnphdniiobdfgfdldlfoikij . 
	Через него мы коммуницируем с сотрудником, через этот плагин показывает нотификации с ссылками на CRM систему.

	Схематически как это работает:
		1) поступает звонок на АТС Binotel, мы обращаемся в CRM для получение данных: имени клиента, ответственного сотрудника и ссылки на контакт в CRM системе
		2) мы через плагин для Chrome выводим эту информацию тем сотрудникам у которых звонит телефон.
		3) сотрудник клакает в нотификации на ссылку и попадает на контакт в CRM системе
 */


/* 
	Пример POST данных, отправляемых Вашему скрипту при поступлении входящего звонка в АТС Binotel.
*/
$postData = array(
	'didNumber' => '0443334000',
	'srcNumber' => '0670219424',
	'companyID' => '3041',
	'requestType' => 'gettingCallSettings'
);

/*
	Разъяснения данных, посылаемых от АТС Binotel:
		didNumber - номер, на который поступил звонок
		srcNumber - номер абонента в поступившем звонке
		companyID - идентификатор компании в АТС Binotel
		requestType - тип запроса

	Другие переменные, которые присылаются, но не описаны выше - являются устаревшими.
	Их использование нежелательно, так как в ближайшее время они будут удалены из API CALL SETTINGS.
*/



/*
	Пример 1. Интеграция Вашей CRM с АТС Binotel.

	Если Вы не нашли клиента у себя в CRM, передавайте ссылку, при которой сотрудник может быстро его создать.

	Параметры:
		linkToCrmUrl - ссылка, которая будет отображатся сотруднику в плагине для Chrome
		linkToCrmTitle - текст ссылки, которая будет отображатся сотруднику в плагине для Chrome

		linkToCrm2Url - ссылка №2, которая будет отображатся сотруднику в плагине для Chrome
		linkToCrm2Title - текст ссылки №2, которая будет отображатся сотруднику в плагине для Chrome
*/
die(json_encode(array(
	'customerData' => array(
		'linkToCrmUrl' => 'http://crm.crm.crm/create-client.php?phone=0443334023',
		'linkToCrmTitle' => 'Создать клиента'
	)
)));



/*
	Пример 2. Интеграция Вашей CRM с АТС Binotel. 

	Когда нашли клиента, передайте информацию о нем.

	Указав данные ответственного сотрудника, можно использовать правило в сценариях входящего звонка звонить сперва ему (для добавления этого правила, нужно обратиться в техподдержку Binotel через e-mail support@binotel.ua, или по телефону 044 333 40 23).
	Также информаиция об ответственном сотруднике будет видна в нотификации плагина для Chrome.

	Параметры:
		name - имя клиента будет отображенно на телефоне сотрудника и в плагине для Chrome. Рекомендуем использовать до 43 символов (ограничение в плагине для Chrome).
		description - дополнительное описание в нотификации плагина для Chrome. Рекомендуем использовать до 70 символов. Ограничение в плагине для Chrome около 115 символов в 3-х строках. Описание сдвигает стандартную информацию в этом поле.
		assignedToEmployeeEmail - email отвественного сотрудника в MyBinotel
		linkToCrmUrl - ссылка, которая будет отображатся сотруднику в плагине для Chrome
		linkToCrmTitle - текст ссылки, которая будет отображатся сотруднику в плагине для Chrome

		linkToCrm2Url - ссылка №2, которая будет отображатся сотруднику в плагине для Chrome
		linkToCrm2Title - текст ссылки №2, которая будет отображатся сотруднику в плагине для Chrome
*/

die(json_encode(array(
	'customerData' => array(
		'name' => 'Имя клиента в CRM',
		'description' => 'Дополнительное описание в нотификации плагина для Chrome',
		'assignedToEmployeeEmail' => 'ic@binotel.ua'
		'linkToCrmUrl' => 'http://crm.crm.crm/show-client.php?id=142',
		'linkToCrmTitle' => 'Перейти в CRM'
	)
)));

/*
	Можно использовать один их трех вариантов идентификации сотрудника:
		1) assignedToEmployeeID   - идентификатор сотрудника в MyBinotel (список индетификаторов всех сотрудников можно получить в API REST, категория settings, метод list-of-employees (детальней смотрите в samples-api-rest-settings.php),
		2) assignedToEmployeeNumber  - внутренний номер сотрудника в АТС Binotel (пример: 904),
		3) assignedToEmployeeEmail   - email сотрудника в MyBinotel.
 */



/*
	Пример 3. Изменение сценария для данного звонка.
	Данную функцию стоит использовать только в случае переопределения стандартного сценария.

	В каких случаях эта функция применима:
		1) Когда Вы определили, что это VIP клиент и Вы хотите, чтобы звонок обрабатывался по VIP сценарию,
		2) Если Вы интернет-оператор, у Вас перестал работать интернет и нужно всем клиентам, которые звонят в Вашу техподдержку, сообщить что Вы скоро все почините.

	Список индетификаторов сценариев можно получить в API REST, категория settings, метод list-of-routes (детальней смотрите в samples-api-rest-settings.php).

	Параметры:
		type - тип сценария (route - обычный сценарий, routeWithTime - временной сценарий)
		id - идентификатор сценария
*/

die(json_encode(array(
	'routeData' => array(
		'type' => 'route',
		'id' => '3810'
	)
)));



/*
	Другие переменные, которые присылаются, но не описаны выше - являются устаревшими.
	Их использование нежелательно, так как в ближайшее время они будут удалены из API CALL SETTINGS.
*/



/* 
	Что будет добавлено в будущем:
*/
die(json_encode(array(
	'variables' => array(
		'variableName' => 'value'
	)
)));